procedure $see_agg
argument local string scalar runno
argument local namelist freqs
argument local numeric series by case agelower = list(16,16,16,25,55,25,16,18,16,20,25,30,35,40,45,50,55,60,62,65,70)
argument local numeric series by case ageupper = list(80,79,24,54,80,80,17,19,19,24,29,34,39,44,49,54,59,61,64,69,80)
argument local string scalar db_path = ""
argument local string scalar pro_path = ""
block

   show vert; length full

   if missing(location(@open.db,"CPSREV"))
      open <ac re> file(local'db_path+"cpscovar_rev.db") as cpsrev
      -local'cpsrevopened = TRUE
   else
      -local'cpsrevopened = FALSE
   end if

   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"lfpr_run"+runno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if

   local'filename = "$TMPDIR/mg_"+$USERID()+"_"+left(system("date +'%Y%m%d%H%M%S%N'"),20)+".db"

   cload file(local'pro_path+"workagg.pro")
   $workagg local'freqs, local'agelower, local'ageupper, local'runno, local'filename
   open <ac re> file(trim(local'filename)) as todb

   device graphics postp
   page margins horizontal 0, vertical 0

   glue null
   overwrite on

   map color postscript C1 "black", C2 "royalblue", C3 "black", C4 "red", &&
                        C5 "slategray", C6 "Rosybrown", C7 "Lemonchiffon", C8 "lavender", &&
                        C9 "silver"

   order 4; order region 1,lines 2, markings 3, series 5
   thickness xthin 1, thin 3, medium 5, thick 7, xthick 9 
   plot style #1 solid, #2 solid, #3 solid, #4 solid

   legend contents description off 
   legend size small

   loop for sfreq in freqs
      execute "freq "+name(sfreq)
      -local'ssfreq = (if name(sfreq) eq "M" then "" else name(sfreq))
      page division rows 3, columns 1
      open <ac over; kind graphic> file("run"+local'runno+"chrt4_"+name(sfreq)+".ps") as chrt4.ps
      channel graphics chrt4.ps

      cell(auto,auto)
      page title #2 center text "Chart 4: Model Trend and Simulation", size medium, color c1

      -local'titles = list("16+","16-19","25+")
      loop for grp in {a16p,a16t19,a25p}
         graph 
            date 1976 to *
            plot color #1 C5, #2 C2, #3 C4
            plot thickness #1 xthin, #2 medium, #3 xthin    

            title #1 size small, text "Ages "+local'titles[nameloc({a16p,a16t19,a25p},grp)], color c1
            if nameloc({a16p,a16t19,a25p},grp) eq 1
               legend size xsmall, fill horizontal
               legend division row auto, column 3
               legend color c1
            else
               legend appear off
            end
            -local'thisfreq = (if upper(name(sfreq)) eq "M" then "" else "q")
            data 100*(todb'id(lout'lfpname+"m_"+name(grp)+local'ssfreq)*(todb'grppopm_&grp&sfreq-cpsrev'tsm_a80&id(thisfreq))+ &&
                      todb'id(lout'lfpname+"f_"+name(grp)+local'ssfreq)*(todb'grppopf_&grp&sfreq-cpsrev'tsf_a80&id(thisfreq)))/ &&
                     (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq-cpsrev'tsm_a80&id(thisfreq)-cpsrev'tsf_a80&id(thisfreq)) <plot name "Actual">, &&
                 100*(todb'modm_&grp&sfreq*todb'grppopm_&grp&sfreq+todb'modf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                     (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) <plot name "Model Trend">, &&
                 100*(todb'predm_&grp&sfreq*todb'grppopm_&grp&sfreq + todb'predf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                     (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) <plot name "Fitted/Simulated">
            draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
            draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
            draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
         end graph

         repo <decimal 5> 100*todb'id(lout'lfpname+"m_"+name(grp)+local'ssfreq) as "Actual!"+name(grp)+"!Men", &&
                          100*todb'id(lout'lfpname+"f_"+name(grp)+local'ssfreq) as "Actual!"+name(grp)+"!Women", &&
                          100*(todb'id(lout'lfpname+"m_"+name(grp)+local'ssfreq)*todb'grppopm_&grp&sfreq+ &&
                               todb'id(lout'lfpname+"f_"+name(grp)+local'ssfreq)*todb'grppopf_&grp&sfreq)/ &&
                              (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) as "Actual!"+name(grp), &&
                          100*todb'modm_&grp&sfreq  as "Model Trend!"+name(grp)+"!Men", &&
                          100*todb'modf_&grp&sfreq as "Model Trend!"+name(grp)+"!Women", &&
                          100*(todb'modm_&grp&sfreq*todb'grppopm_&grp&sfreq+ &&
                               todb'modf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                               (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) as "Model Trend!"+name(grp), &&
                          100*todb'predm_&grp&sfreq as "Fitted/!Simulated!"+name(grp)+"!Men", &&
                          100*todb'predf_&grp&sfreq as "Fitted/!Simulated!"+name(grp)+"!Women", &&
                          100*(todb'predm_&grp&sfreq*todb'grppopm_&grp&sfreq+ &&
                               todb'predf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                              (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) as "Fitted/!Simulated!"+name(grp)

      end loop

      close chrt4.ps
      execute "!(ps2pdf run"+local'runno+"chrt4_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"chrt4_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"chrt4_"+name(sfreq)+".ps)&"

      page title #2 center text "Chart 5: Model Trend and Simulation", size medium, color c1

      open <ac over; kind graphic> file("run"+local'runno+"chrt5_"+name(sfreq)+".ps") as chrt5.ps
      channel graphics chrt5.ps

      -local'titles = list("16-17","18-19","20-24","16-24","25-29","30-34","35-39","40-44","45-49","50-54","55-59","60-61","62-64","65-69","70+","16-79","25-54","55+")
      -local'ch5grps = {a16t17,a18t19,a20t24,a16t24,a25t29,a30t34,a35t39,a40t44,a45t49,a50t54,a55t59,a60t61,a62t64,a65t69,a70p,a16t79,a25t54,a55p} 
      loop for grp in local'ch5grps
         graph 
            date 1976 to *
            plot color #1 C5, #2 C2, #3 C4
            plot thickness #1 xthin, #2 medium, #3 xthin    

            title #1 size small, text "Ages "+local'titles[nameloc(local'ch5grps,grp)], color c1
            if nameloc(local'ch5grps,grp) mod 3 eq 1
               legend appear on
               legend size xsmall, fill horizontal
               legend division row auto, column 3
               legend color c1
            else
               legend appear off
            end
 
            data 100*(todb'id(lout'lfpname+"m_"+name(grp)+local'ssfreq)*todb'grppopm_&grp&sfreq+ &&
                      todb'id(lout'lfpname+"f_"+name(grp)+local'ssfreq)*todb'grppopf_&grp&sfreq)/ &&
                     (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) <plot name "Actual">, &&
                 100*(todb'modm_&grp&sfreq*todb'grppopm_&grp&sfreq+ &&
                      todb'modf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                     (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) <plot name "Model Trend">, &&
                 100*(todb'predm_&grp&sfreq*todb'grppopm_&grp&sfreq+ &&
                      todb'predf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                     (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) <plot name "Fitted/Simulated">
            draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
            draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
            draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beg; glue dot> &&
               (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
         end graph
 
         repo <decimal 5> 100*todb'id(lout'lfpname+"m_"+name(grp)+local'ssfreq) as "Actual!"+name(grp)+"!Men", &&
                          100*todb'id(lout'lfpname+"f_"+name(grp)+local'ssfreq) as "Actual!"+name(grp)+"!Women", &&
                          100*(todb'id(lout'lfpname+"m_"+name(grp)+local'ssfreq)*todb'grppopm_&grp&sfreq+ &&
                               todb'id(lout'lfpname+"f_"+name(grp)+local'ssfreq)*todb'grppopf_&grp&sfreq)/ &&
                              (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) as "Actual!"+name(grp), &&
                          100*todb'modm_&grp&sfreq  as "Model Trend!"+name(grp)+"!Men", &&
                          100*todb'modf_&grp&sfreq as "Model Trend!"+name(grp)+"!Women", &&
                          100*(todb'modm_&grp&sfreq*todb'grppopm_&grp&sfreq+ &&
                               todb'modf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                              (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) as "Model Trend!"+name(grp), &&
                          100*todb'predm_&grp&sfreq as "Fitted/!Simulated!"+name(grp)+"!Men", &&
                          100*todb'predf_&grp&sfreq as "Fitted/!Simulated!"+name(grp)+"!Women", &&
                          100*(todb'predm_&grp&sfreq*todb'grppopm_&grp&sfreq+ &&
                               todb'predf_&grp&sfreq*todb'grppopf_&grp&sfreq)/ &&
                              (todb'grppopm_&grp&sfreq+todb'grppopf_&grp&sfreq) as "Fitted/!Simulated!"+name(grp)
      end loop

      close chrt5.ps
      execute "!(ps2pdf run"+local'runno+"chrt5_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"chrt5_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"chrt5_"+name(sfreq)+".ps)&"

      page title #1 null
      page title #2 null
      page division rows 1, columns 1

      device graphics postl
      open <ac over; kind graphic> file("run"+local'runno+"_Fig1_"+name(sfreq)+".ps") as fig1
      channel graphics fig1

      graph 
         date 1976:1 to lastvalue(todb'id(lout'lfpname+"_a16p"+local'ssfreq))

         title #1 size med, text "Labor Force Participation Rate", color c1
         legend size xsmall, fill horizontal
         legend division row 1, column auto
         legend color c1

         data 100*todb'id(lout'lfpname+"_a16p"+local'ssfreq) <plot name "Actual", color C5,thickness xthin>, &&
              100*(todb'modm_a16p&sfreq*todb'grppopm_a16p&sfreq+todb'modf_a16p&sfreq*todb'grppopf_a16p&sfreq)/ &&
                  (todb'grppopm_a16p&sfreq+todb'grppopf_a16p&sfreq) <plot name "Model Trend", color C3, thickness medium>, &&
              100*(todb'predm_a16p&sfreq*todb'grppopm_a16p&sfreq+todb'predf_a16p&sfreq*todb'grppopf_a16p&sfreq)/ &&
                  (todb'grppopm_a16p&sfreq+todb'grppopf_a16p&sfreq) <plot name "Fitted", color C4, thickness xthin>
      end graph

      close fig1
      execute "!(ps2pdf run"+local'runno+"_Fig1_"+name(sfreq)+".ps; "+&&
                "gv --orientation=landscape run"+local'runno+"_Fig1_"+name(sfreq)+".ps)&"

      device graphics postp
      page division rows 2, columns 2

      if (exists(lout'runtime))
         page title area length standard
         page title #1 right text datefmt(lout'runtime), font f10, size xsmall, color c1
      end if
      page divi rows 2, columns 2
      page frame on

      open <ac over; kind graphic> file("run"+local'runno+"agg_"+name(sfreq)+".ps") as agg.ps
      channel graphics agg.ps

      plot color #1 C5, #2 C3, #3 C2, #4 C4, #5 C6
      plot thickness #1 xthin, #2 medium, #3 medium, #4 xthin    

      cell(1,1 to 2)
      graph 
         date 1963 to *

         title #1 size med, text "Aggregated LFPR", color c1
         legend size xsmall, fill horizontal
         legend division row 1, column auto
         legend color c1

         data 100*todb'id(lout'lfpname+"_a16p"+local'ssfreq) <plot name "Actual">, &&
              100*(todb'modm_a16p&sfreq*todb'grppopm_a16p&sfreq+todb'modf_a16p&sfreq*todb'grppopf_a16p&sfreq)/ &&
                  (todb'grppopm_a16p&sfreq+todb'grppopf_a16p&sfreq) <plot name "Model Trend">, &&
              100*(todb'predm_a16p&sfreq*todb'grppopm_a16p&sfreq+todb'predf_a16p&sfreq*todb'grppopf_a16p&sfreq)/ &&
                  (todb'grppopm_a16p&sfreq+todb'grppopf_a16p&sfreq) <plot name "Fitted/Simulated">
         draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
         draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
         draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
         draw line <depict axis bottom, color C9,placement beginning; glue dot> &&
            (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
         draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
            (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
         draw line <depict axis bottom, color C9, placement beg; glue dot> &&
            (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
      end graph

      loop for gg in {m,f}
         -local'col = nameloc({m,f},gg)
         cell(2,local'col)
         -local'gtitle = (if name(gg) eq "M" then "Men" else "Women")
         graph 
            date 1976 to *

            plot color #1 C5, #2 C2, #3 C4
            plot thickness #1 xthin, #2 medium, #3 xthin
            title #1 size med, text local'gtitle, color c1
            legend size xsmall, fill horizontal
            legend division row 1, column auto
            legend color c1
            tick label size xsmall

            data 100*todb'id(lout'lfpname+name(gg)+"_a16p"+local'ssfreq) <plot name "Actual">, &&
                 100*todb'mod&gg&_a16p&sfreq <plot name "Model Trend">, &&
                 100*todb'pred&gg&_a16p&sfreq <plot name "Fitted/Simulated">

            draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
            draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
            draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
            draw line <depict axis bottom, color C9,placement beginning; glue dot> &&
               (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beg; glue dot> &&
               (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
         end graph
      end loop

      repo 100*(todb'modm_a16p&sfreq*todb'grppopm_a16p&sfreq+todb'modf_a16p&sfreq*todb'grppopf_a16p&sfreq)/ &&
               (todb'grppopm_a16p&sfreq+todb'grppopf_a16p&sfreq) as "Agg Trend"
      refresh

      loop for grp = 1 to lastvalue(local'agelower)
         legend size xsmall
         -local'thisgroup = "a"+string(local'agelower[grp])+(if ageupper[grp] EQ 80 then "P" else "t"+string(ageupper[grp]))
          next if (upper(local'thisgroup) eq "A16P")

         cell(1,1 to 2)
         graph 
            date 1976 to *
            plot color #1 C5, #2 C2, #3 C4
            plot thickness #1 xthin, #2 medium, #3 xthin

            title #1 size med, text "Aggregated LFPR ("+thisgroup+")", color c1
            legend size xsmall, fill horizontal
            legend division row auto, column 3
            legend color c1

            try
               data 100*(todb'id(lout'lfpname+"m_"+thisgroup+local'ssfreq)*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                         todb'id(lout'lfpname+"f_"+thisgroup+local'ssfreq)*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                        (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq))) <plot name "Actual">, &&
                    100*(todb'id("modm_"+thisgroup+name(sfreq))*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                         todb'id("modf_"+thisgroup+name(sfreq))*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                        (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq))) <plot name "Model Trend">, &&
                    100*(todb'id("predm_"+thisgroup+name(sfreq))*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                         todb'id("predf_"+thisgroup+name(sfreq))*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                        (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq))) <plot name "Fitted/Simulated">
            otherwise
               signal continue: "Escaped error: "+ERRORTEXT
               data 100*(todb'id(lout'lfpname+"m_"+thisgroup+local'ssfreq)*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                         todb'id(lout'lfpname+"f_"+thisgroup+local'ssfreq)*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                        (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq))) <plot name "Actual">, &&
                    100*(todb'id("modm_"+thisgroup+name(sfreq))*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                         todb'id("modf_"+thisgroup+name(sfreq))*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                        (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq))) <plot name "Model Trend">, &&
                    100*(todb'id("predm_"+thisgroup+name(sfreq))*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                         todb'id("predf_"+thisgroup+name(sfreq))*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                        (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq))) <plot name "Fitted/Simulated">
            end try

            draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
            draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
            draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beg; glue dot> &&
               (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
         end graph

         loop for gg in {m,f}
            -local'col = nameloc({m,f},gg)
            cell(2,local'col)
            -local'gtitle = (if name(gg) eq "M" then "Men" else "Women")
            graph 
               date 1976 to *
               plot color #1 C5, #2 C2, #3 C4
               plot thickness #1 xthin, #2 medium, #3 xthin
               tick label size xsmall

               title #1 size med, text local'gtitle, color c1
               legend size xsmall, fill horizontal
               legend division row auto, column 3
               legend color c1

               data 100*todb'id(lout'lfpname+name(gg)+"_"+thisgroup+local'ssfreq) <plot name "Actual">, &&
                    100*todb'id("mod"+name(gg)+"_"+thisgroup+name(sfreq)) <plot name "Model Trend">, &&
                    100*todb'id("pred"+name(gg)+"_"+thisgroup+name(sfreq)) <plot name "Fitted/Simulated">

               draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
               draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beg; glue dot> &&
                  (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
            end graph

         end loop
      end loop

      close agg.ps
      execute "!(ps2pdf run"+local'runno+"agg_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"agg_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"agg_"+name(sfreq)+".ps)&"

      block 
         device graphics postl
         page frame off
         page division rows 1, columns 1
         page title null
                  
         loop for gg in {m,f}
            open <ac over; kind graphic> file("run"+local'runno+"Fig2"+name(gg)+"_"+name(sfreq)+".ps") as fig2ps
            channel graphics fig2ps

            cell(auto,auto)
            graph 
               date 1976:1 to lastvalue(todb'id(lout'lfpname+"_"+thisgroup+local'ssfreq))
               title #1 size med, text "Labor Force Participation Rate", color c1
               title #2 size med, text ""+(if name(gg) eq "M" then "Men" else "Women")+" Aged 25 to 54"
               legend size small, fill horizontal
               legend division row 1, column auto
               legend color c1

               data 100*todb'id(lout'lfpname+name(gg)+"_a25t54"+local'ssfreq) <plot name "Actual", color c5, thickness xthin>, &&
                    100*todb'id("mod"+name(gg)+"_a25t54"+name(sfreq)) <plot name "Model Trend", color c3, thickness medium>, &&
                    100*todb'id("pred"+name(gg)+"_a25t54"+name(sfreq)) <plot name "Fitted", color c4, thickness xthin>

            end graph
            close fig2ps

            execute "!(ps2pdf run"+local'runno+"Fig2"+name(gg)+"_"+name(sfreq)+".ps; "+&&
                    "gv --orientation=landscape run"+local'runno+"Fig2"+name(gg)+"_"+name(sfreq)+".ps)&"
         end loop

         device graphics postp
      end block
   end loop -- freq loop

   if (not missing(location(@open.db,"TODB")))
      close todb
      system "rm -f "+trim(local'filename)
   end if

   if local'loutopened
      close lout
   end if

   if local'cpsrevopened
      close cpsrev
   end if

end block
end procedure
